//database migration
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// Columns to be added to the schools table
$columnsToAdd = [
    'school_logo',
];

// Filter out the columns that already exist in the schools table
$columnsToAdd = array_filter($columnsToAdd, function ($column) {
    return !Schema::hasColumn('schools', $column);
});

// Check if there are columns to add before modifying the table
if (!empty($columnsToAdd)) {
    Schema::table('schools', function (Blueprint $table) use ($columnsToAdd) {
        foreach ($columnsToAdd as $column) {
            $table->string($column)->nullable();
        }
    });
}

// Columns to be added to the  subscriptions table
$columnsToAdd = [
    'studentLimit',
];


// Filter out the columns that already exist in the schools table
$columnsToAdd = array_filter($columnsToAdd, function ($column) {
    return !Schema::hasColumn('subscriptions', $column);
});

// Check if there are columns to add before modifying the table
if (!empty($columnsToAdd)) {
    Schema::table('subscriptions', function (Blueprint $table) use ($columnsToAdd) {
        foreach ($columnsToAdd as $column) {
            $table->string($column)->nullable();
        }
    });
}


$school_status = DB::table('users')->where('role_id', 7)->get();

DB::table('users')->where('role_id', 7)->update(['status' => '1']);


$subcriptions = DB::table('subscriptions')->get();

foreach($subcriptions as $subcription)
{
    DB::table('subscriptions')->update(['studentLimit' => 'Unlimited']);
}


// Columns to be added to the  subscriptions table
$columnsToAdd = [
    'studentLimit',
    'features',
];

// Filter out the columns that already exist in the schools table
$columnsToAdd = array_filter($columnsToAdd, function ($column) {
    return !Schema::hasColumn('packages', $column);
});

// Check if there are columns to add before modifying the table
if (!empty($columnsToAdd)) {
    Schema::table('packages', function (Blueprint $table) use ($columnsToAdd) {
        foreach ($columnsToAdd as $column) {
            $table->string($column)->nullable();
        }
    });
}